 ; Ŀ
 ;   Shift - search and replace with goto and log file of changes.         
 ;   Copyright 1996, 2010 by Rocket Software Ltd.                          
 ;   Note: may need to be updated to work with different spaces.           
 ;   Entropy - the original warm and fuzzy.                                
 ; 

 ; Ŀ
 ;   Datt - returns a date and time string.                                
 ; 
 (DEFUN DATT (/ dd cd yy mm da hour min ampm)
  (setq dd (rtos (fix (setq cd (getvar "cdate")))))
  (setq yy (substr dd 3 2) mm (substr dd 5 2) da (substr dd 7 2))
  (setq hour (fix (* 100 (- cd (fix cd)))))
  (if (< 12 hour)
      (progn
            (setq hour (- hour 12))
            (setq ampm "pm"))
            (setq ampm "am"))
  (setq min (fix (* 100 (- (* 100 cd) (fix (* 100 cd))))))
  (setq min (itoa min))
  (if (> 2 (strlen min)) (setq min (strcat "0" min)))
  (strcat  yy "." mm "." da ", " (itoa hour) ":" min ampm))
 ; Ŀ
 ;   Datt end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Rift - write to a file a header composed of the drawing    
 ;   name and the current date and time.                                   
 ;   Takes two arguments - the name of the file, and a list of data        
 ;   strings, each of which is padded to length and placed on its own      
 ;   line in the box.                                                      
 ; 
 (DEFUN RIFT (filnam chdat / fn dd yy aa bb cc f1 hh nop ii pos sub)
  (if (setq fn (open filnam "a"))
      (progn
 ; Ŀ
 ;   Make the header filename and date string.                             
 ; 
           (setq nop (getvar "dwgname"))
           (setq nop (strcat (strcase (substr nop 1 1))
                     (strcase (substr nop 2) t)))
           (setq ii (strcat "   " nop "  -  " (datt)))
           (while (< (strlen ii) 77) (setq ii (strcat ii " ")))
           (setq ii (strcat ii ""))
 ; Ŀ
 ;   Write the top line of the header box.                                 
 ; 
           (setq aa "")
           (write-line (strcat " " aa aa "Ŀ") fn)
 ; Ŀ
 ;   Write file name and current date string.                              
 ; 
           (write-line ii fn)
 ; Ŀ
 ;   Pad each string in the list Chdat to length, add a vertical box       
 ;   line to each end, and write it to the file.                           
 ; 
           (while (setq sub (car chdat))
                  (setq chdat (cdr chdat))
                  (setq ii (strcat "   " sub))
                  (while (< (strlen ii) 77) (setq ii (strcat ii " ")))
                  (setq ii (strcat ii ""))
                  (write-line ii fn))
 ; Ŀ
 ;   Write the bottom line of the header box.                              
 ; 
           (write-line (strcat " " aa aa "") fn)
 ; Ŀ
 ;   And close the file.                                                   
 ; 
           (close fn))))
 ; Ŀ
 ;   Rift end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Chicle - Process a text or attribute entity.               
 ;   1. If the entity is offscreen, pan to it.                             
 ;   2. Box the text entity or attribute.                                  
 ;   3. Ask whether to change it.  Offer the original and potential        
 ;      changed strings, and the number of changes.                        
 ;   4. Change the entity if required.                                     
 ;   5. Update variables for the total number of changes made and the      
 ;      number of strings changed.                                         
 ;   6. Write the result to the log file.                                  
 ;   7. Unbox string. (mbox enam)                                          
 ;                                                                         
 ;   Takes three arguments - the entity ename                              
 ;                           the old string                                
 ;                           the new string                                
 ;   Returns nothing.                                                      
 ; 
 (DEFUN CHICLE (enam oldstr newstr /)
  (if (null (ison enam)) (panto enam))    
  (mbox enam)
  (setq txt (cdr (setq asoc1 (assoc 1 (setq entt (entget enam))))))
  (setq txt2 (car (setq chlis (chug oldstr newstr txt))))
  (setq chgnum (cadr chlis))
  (initget 0 "Yes No")
  (setq go (getkword (strcat "Change " txt " to " txt2
                                     " (" (itoa chgnum) ") <Y>? ")))
  (mbox enam)
  (setq fn (open "logfile.txt" "a"))
  (write-line txt fn)
  (if (or (null go) (= go "Yes"))
      (progn
           (entmod (subst (cons 1 txt2) asoc1 entt))
           (entupd enam)
           (setq strchg (1+ strchg))
           (setq changs (+ changs chgnum))
           (write-line txt2 fn)
           (if (> chgnum 1)
               (write-line (strcat (itoa chgnum) " changes") fn)))
      (write-line "*** Not Changed ***" fn))
  (write-line "" fn)
  (close fn)
 (princ))
 ; Ŀ
 ;   Chicle end.                                                           
 ; 

 ; Ŀ
 ;   Sherr - error handler.                                                
 ; 
 (DEFUN SHERR (shk / pos entt enam sublst vall)
  (if fn (close fn))
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Sherr end.                                                            
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Screw2 - find the area currently onscreen.                 
 ;   Returns the maximum and minimum x and y coordinates as a list.        
 ;   See also Screw, which returns the centre 75% of the screen.           
 ; 
 (DEFUN SCREW2 (/ scrnsz scrat vhhght ctr vhwid maxx minx maxy miny)
 ; Get the screen size variables.
  (setq scrnsz (getvar "screensize"))         ; view height & width (pixels)
  (setq scrat (/ (car scrnsz) (cadr scrnsz))) ; view width/height ratio
  (setq vhhght (/ (getvar "viewsize") 2.0))   ; view half height in dwg units
  (setq ctr (getvar "viewctr"))               ; centre point of screen
  (setq vhwid (* vhhght scrat))               ; view halfwidth
 ; Find the minimum and maximum x and y coordinates.
  (setq maxx (+ (car ctr) vhwid))
  (setq minx (- (car ctr) vhwid))
  (setq maxy (+ (cadr ctr) vhhght))
  (setq miny (- (cadr ctr) vhhght))
 ; Find the coordinates of the screen corners
;  (setq aa (list minx miny))
;  (setq bb (list minx maxy))
;  (setq cc (list maxx maxy))
;  (setq dd (list maxx miny))
;  (grdraw aa bb 7 1)
;  (grdraw bb cc 7 1)
;  (grdraw cc dd 7 1)
;  (grdraw dd aa 7 1)
 (list maxx minx maxy miny))
 ; Ŀ
 ;   Screw2 end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Ison - see if a text entity is entirely on the screen.     
 ; 
 (DEFUN ISON (enam / tlist ur lr ll ul urx ury lrx lry llx lly ulx uly tmaxx
                                 tminx tmaxy tminy plist maxx minx maxy miny)
  (setq tlist (tbox enam))
  (setq ur (nth 0 tlist))
  (setq lr (nth 1 tlist))
  (setq ll (nth 2 tlist))
  (setq ul (nth 3 tlist))
  (setq urx (car ur))
  (setq ury (cadr ur))
  (setq lrx (car lr))
  (setq lry (cadr lr))
  (setq llx (car ll))
  (setq lly (cadr ll))
  (setq ulx (car ul))
  (setq uly (cadr ul))
  (setq tmaxx (max urx lrx llx ulx))
  (setq tminx (min urx lrx llx ulx))
  (setq tmaxy (max ury lry lly uly))
  (setq tminy (min ury lry lly uly))
  (setq plist (screw2))
  (setq maxx (nth 0 plist))
  (setq minx (nth 1 plist))
  (setq maxy (nth 2 plist))
  (setq miny (nth 3 plist))
  (if (and (<= tmaxx maxx) (>= tminx minx) (<= tmaxy maxy) (>= tminy miny))
      T ()))
 ; Ŀ
 ;   Ison end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Setmag - zoom the screen to a reasonable size for          
 ;   viewing teyt entities.                                                
 ; 
 (DEFUN SETMAG (/ minn maxx mido siz)
  (setq minn (reverse (cdr (reverse (getvar "extmin")))))
  (setq maxx (reverse (cdr (reverse (getvar "extmax")))))
  (setq mido (polar minn (angle minn maxx) (/ (distance minn maxx) 2)))
  (setq siz (* 150 (misps)))
  (command "zoom" "c" mido siz))
 ; Ŀ
 ;   Setmag end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Mbox - outline a text entity ten times.                    
 ;   Takes one argument, an ename.  Note that calling this twice will      
 ;   erase the marker box.                                                 
 ; 
 (DEFUN MBOX (enam / cutdis)
  (setq cutdis 0.2)
  (repeat 10
          (tshow enam cutdis -1)
          (setq cutdis (+ cutdis 0.1))))
 ; Ŀ
 ;   Mbox end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Tshow - outline a text entity.                             
 ;   Takes three arguments - Enam, the text entity name.                   
 ;                           Cutdis, the distance of the marker line from  
 ;                           the text as a fraction of the text height.    
 ;                           Grcol, the temporary marker colour.           
 ; 
 (DEFUN TSHOW (enam cutdis grcol / entt tblst rota cc dd bheigt bwidth llangg
          lldist ll ul lr ur outdis lll uul llr uur indis inll inul inlr inur)
  (setq entt (entget enam))
  (setq tblst (textbox entt))
  (setq rota (cdr (assoc 50 entt)))
  (setq cc (car tblst))                    ; ll offset from 10 of text
  (setq dd (cadr tblst))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 entt)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
  (setq outdis (* (sqrt 2) cutdis bheigt))
  (setq lll (polar ll (+ rota (* pi 1.25)) outdis))
  (setq uul (polar ul (+ rota (* pi 0.75)) outdis))
  (setq llr (polar lr (+ rota (* pi 1.75)) outdis))
  (setq uur (polar ur (+ rota (* pi 0.25)) outdis))
  (setq indis (* 0.01 bheigt))
  (setq inll (polar lll (+ rota (* pi 0.25)) indis))
  (setq inul (polar uul (+ rota (* pi 1.75)) indis))
  (setq inlr (polar llr (+ rota (* pi 0.75)) indis))
  (setq inur (polar uur (+ rota (* pi 1.25)) indis))
  (grdraw lll uul grcol)
  (grdraw uul uur grcol)
  (grdraw uur llr grcol)
  (grdraw llr lll grcol)
 (princ))
 ; Ŀ
 ;   Tshow end.                                                            
 ; 

 ; Ŀ
 ;   Panto - pan the middle of a text entity to the centre of the screen.  
 ; 
 (DEFUN PANTO (enam / corlst ur lr ll ul pa)
 ; Ŀ
 ;   Find the centre point of the text entity.                             
 ; 
  (setq corlst (tbox enam))
  (setq ur (nth 0 corlst))
  (setq lr (nth 1 corlst))
  (setq ll (nth 2 corlst))
  (setq ul (nth 3 corlst))
  (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
 ; Ŀ
 ;   And pan it to the centre of the screen.                               
 ; 
  (command "pan" pa (getvar "viewctr"))
 (princ))
 ; Ŀ
 ;   Panto end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Tbox - return the corner points of a text entity.          
 ; 
 (DEFUN TBOX (enam / aa bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (if (setq bb (textbox aa))
      (progn
          (setq rota (cdr (assoc 50 aa)))
          (setq cc (car bb))                    ; ll offset from 10 of text
          (setq dd (cadr bb))                   ; ur offset from 10 of text
          (setq bheigt (- (cadr dd) (cadr cc)))
          (setq bwidth (- (car dd) (car cc)))
          (setq llangg (angle (list 0 0) cc))
          (setq lldist (distance (list 0 0) cc))
          (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
          (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
          (setq lr (polar ll rota bwidth))
          (setq ur (polar lr (+ rota (/ pi 2)) bheigt))))
 (list ur lr ll ul))
 ; Ŀ
 ;   Tbox end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Screw - find the main (centre 75%) area onscreen.          
 ; 
 (DEFUN SCREW (/ ra scrnsz scrat vhhght ctr vhwid 34hgt 34wid maxx minx maxy
                                                            miny aa bb cc dd)
 ; Get the screen size variables.
  (setq scrnsz (getvar "screensize"))         ; view height & width (pixels)
  (setq scrat (/ (car scrnsz) (cadr scrnsz))) ; view width/height ratio
  (setq vhhght (/ (getvar "viewsize") 2.0))   ; view half height in dwg units
  (setq ctr (getvar "viewctr"))               ; centre point of screen
  (setq vhwid (* vhhght scrat))               ; view halfwidth
 ; Find the minimum and maximum x and y coordinates.
  (setq 34hgt (* 0.75 vhhght))
  (setq 34wid (* 0.75 vhwid))
  (setq maxx (+ (car ctr) 34wid))
  (setq minx (- (car ctr) 34wid))
  (setq maxy (+ (cadr ctr) 34hgt))
  (setq miny (- (cadr ctr) 34hgt))
 ; Find the coordinates of the screen corners
  (setq aa (list minx miny))
  (setq bb (list minx maxy))
  (setq cc (list maxx maxy))
  (setq dd (list maxx miny))
  (grdraw aa bb 7 1)
  (grdraw bb cc 7 1)
  (grdraw cc dd 7 1)
  (grdraw dd aa 7 1)
 (princ))
 ; Ŀ
 ;   Screw end.                                                            
 ; 

 ; Ŀ
 ;   Shift.                                                                
 ; 
 (DEFUN C:SHIFT (/ ss num enam txt txa)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq esav *error*)                    ; save the previous error handler
  (setq *error* sherr)                   ; and install the new one
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Initialise counters for current entity type changes.                  
 ;   Note that these are global variables so that Chicle can get at them.  
 ; 
  (setq changs 0)     ; total changes
  (setq strchg 0)     ; strings changed
 ; Ŀ
 ;   Get the string to find and the replacement string.                    
 ; 
  (setq cont t)
  (while cont
        (setq oldstr (getstring t "\nString to locate: "))
        (if (= oldstr "")
            (princ "Can't search for nothing.")
            (setq cont nil)))
  (setq newstr (getstring t "Replacement string: "))
 ; Ŀ
 ;   Make change data line for the log file.                               
 ; 
  (setq chdat (list (strcat oldstr " replaced with " newstr)))
 ; Ŀ
 ;   Write the current drawing name and other data to the log file.        
 ; 
  (rift "logfile.txt" chdat)
 ; Ŀ
 ;   Zoom in to the correct magnification.                                 
 ; 
  (setmag)
 ; Ŀ
 ;   Get a selection set of all text in the drawing.                       
 ; 
  (setq ss (ssget "X" '((0 . "TEXT"))))
  (setq lenstr (strcat "/" (itoa (sslength ss)) ":Txt"))
 ; Ŀ
 ;   While there are text entities in the selection set.                   
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
         (grtext -2 (strcat (itoa (setq num (1+ num))) lenstr))
         (if (wcmatch txt (strcat "*" oldstr "*"))
             (chicle enam oldstr newstr)))
 ; Ŀ
 ;   Get a selection set of all text in the drawing.                       
 ; 
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Bl")))
 ; Ŀ
 ;   While there are block insertions in the selection set.                
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq esub enam)
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget (setq esub
                                                          (entnext esub)))))))
                (setq txt (cdr (assoc 1 entt)))
                (if (wcmatch txt (strcat "*" oldstr "*"))
                    (chicle esub oldstr newstr))))
 ; Ŀ
 ;   Sum up.                                                               
 ; 
  (write-line (strcat (itoa changs) " change" (if (/= changs 1) "s" "") " in "
                      (itoa strchg) " entit"  (if (/= strchg 1) "ies." "y.")))
 ; Ŀ
 ;   Restore error handler, fast zoom to extents, end.                     
 ; 
  (setq *error* esav)        ; restore the original error handler
  (setq a (getvar "extmin"))
  (setq b (getvar "extmax"))
  (command "zoom" "w" a b)
 (princ))